define(['app', 'authentication_service', 'PatientFHIRService'], function (app) {
	"use strict";
	app.controller('FooterController', function ($scope, PatientFHIRService, authenticationService) {
		$scope.userName = null;
		$scope.advocateForName = null;
		$scope.facilityName = null;
		$scope.loggedInUser = {};
		if (authenticationService.isAuthenticated()) {
			PatientFHIRService.getPatientContext().then(function(loggedInUser){
				loadUserDetails(loggedInUser);
			});
		}

		function loadUserDetails(user) {
			if (user) {
				$scope.userName = user.name[0].text;

				//TODO: THIS FUNCTIONALITY NEEDS TO BE REVISITED, WITH CURRENT IMPLEMENTATION, NO WAY TO DETERMINE IF LOGGED IN USER IS AN ADVOCATE FOR ANOTHER USER
				
				// if (isAdvocate(user)) {
				// 	$scope.advocateForName = user.name[0].text;
				// } else if (user.facilityName) {
				// 	$scope.facilityName = user.facilityName;
				// }
			}
		}

		function isAdvocate(user) {
			return user.patient.patientIdentifier !== null
				&& user.patient.patientIdentifier.uniqueId !== null
				&& user.id !== user.patient.patientIdentifier.uniqueId;
		};
	});
});